/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.world.feature;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Random;
import java.util.function.Function;
import mod.beethoven92.betterendforge.common.block.BlockProperties;
import mod.beethoven92.betterendforge.common.block.template.FurBlock;
import mod.beethoven92.betterendforge.common.init.ModBlocks;
import mod.beethoven92.betterendforge.common.init.ModTags;
import mod.beethoven92.betterendforge.common.util.BlockHelper;
import mod.beethoven92.betterendforge.common.util.ModMathHelper;
import mod.beethoven92.betterendforge.common.util.sdf.SDF;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFDisplacement;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFScale3D;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFSubtraction;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFTranslate;
import mod.beethoven92.betterendforge.common.util.sdf.primitive.SDFSphere;
import mod.beethoven92.betterendforge.common.world.generator.OpenSimplexNoise;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.material.Material;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class TenaneaBushFeature
extends Feature<NoFeatureConfig> {
    private static final Function<BlockState, Boolean> REPLACE;
    private static final Direction[] DIRECTIONS;

    public TenaneaBushFeature() {
        super(NoFeatureConfig.field_236558_a_);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        if (!world.func_180495_p(pos.func_177977_b()).func_177230_c().func_203417_a(ModTags.END_GROUND)) {
            return false;
        }
        float radius = ModMathHelper.randRange(1.8f, 3.5f, rand);
        OpenSimplexNoise noise = new OpenSimplexNoise(rand.nextInt());
        BlockState leaves = ((Block)ModBlocks.TENANEA_LEAVES.get()).func_176223_P();
        SDF sphere = new SDFSphere().setRadius(radius).setBlock(leaves);
        sphere = new SDFScale3D().setScale(1.0f, 0.75f, 1.0f).setSource(sphere);
        sphere = new SDFDisplacement().setFunction(vec -> Float.valueOf((float)noise.eval((double)vec.func_195899_a() * 0.2, (double)vec.func_195900_b() * 0.2, (double)vec.func_195902_c() * 0.2) * 3.0f)).setSource(sphere);
        sphere = new SDFDisplacement().setFunction(vec -> Float.valueOf(ModMathHelper.randRange(-2.0f, 2.0f, rand))).setSource(sphere);
        sphere = new SDFSubtraction().setSourceA(sphere).setSourceB(new SDFTranslate().setTranslate(0.0f, -radius, 0.0f).setSource(sphere));
        sphere.setReplaceFunction(REPLACE);
        ArrayList support = Lists.newArrayList();
        sphere.addPostProcess(info -> {
            if (info.getState().func_177230_c() instanceof LeavesBlock) {
                int distance = info.getPos().func_218139_n((Vector3i)pos);
                if (distance < 7) {
                    if (rand.nextInt(4) == 0 && info.getStateDown().func_196958_f()) {
                        BlockPos d = info.getPos().func_177977_b();
                        support.add(d);
                    }
                    ModMathHelper.shuffle(DIRECTIONS, rand);
                    for (Direction d : DIRECTIONS) {
                        if (!info.getState(d).func_196958_f()) continue;
                        info.setBlockPos(info.getPos().func_177972_a(d), (BlockState)((Block)ModBlocks.TENANEA_OUTER_LEAVES.get()).func_176223_P().func_206870_a((Property)FurBlock.FACING, (Comparable)d));
                    }
                    return (BlockState)info.getState().func_206870_a((Property)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(distance));
                }
                return Blocks.field_150350_a.func_176223_P();
            }
            return info.getState();
        });
        sphere.fillRecursive((IWorld)world, pos);
        BlockState stem = ((Block)ModBlocks.TENANEA.bark.get()).func_176223_P();
        BlockHelper.setWithoutUpdate((IWorldWriter)world, pos, stem);
        for (Direction d : Direction.values()) {
            BlockPos p = pos.func_177972_a(d);
            if (!world.func_175623_d(p)) continue;
            BlockHelper.setWithoutUpdate((IWorldWriter)world, p, (BlockState)leaves.func_206870_a((Property)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(1)));
        }
        BlockPos.Mutable mut = new BlockPos.Mutable();
        BlockState top = (BlockState)((Block)ModBlocks.TENANEA_FLOWERS.get()).func_176223_P().func_206870_a(BlockProperties.TRIPLE_SHAPE, (Comparable)((Object)BlockProperties.TripleShape.TOP));
        BlockState middle = (BlockState)((Block)ModBlocks.TENANEA_FLOWERS.get()).func_176223_P().func_206870_a(BlockProperties.TRIPLE_SHAPE, (Comparable)((Object)BlockProperties.TripleShape.MIDDLE));
        BlockState bottom = (BlockState)((Block)ModBlocks.TENANEA_FLOWERS.get()).func_176223_P().func_206870_a(BlockProperties.TRIPLE_SHAPE, (Comparable)((Object)BlockProperties.TripleShape.BOTTOM));
        support.forEach(bpos -> {
            BlockState state = world.func_180495_p(bpos);
            if (state.func_196958_f() || state.func_203425_a((Block)ModBlocks.TENANEA_OUTER_LEAVES.get())) {
                int count = ModMathHelper.randRange(3, 8, rand);
                mut.func_189533_g((Vector3i)bpos);
                if (world.func_180495_p(mut.func_177984_a()).func_203425_a((Block)ModBlocks.TENANEA_LEAVES.get())) {
                    BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, top);
                    for (int i = 1; i < count; ++i) {
                        mut.func_185336_p(mut.func_177956_o() - 1);
                        if (!world.func_175623_d(mut.func_177977_b())) break;
                        BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, middle);
                    }
                    BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, bottom);
                }
            }
        });
        return true;
    }

    static {
        DIRECTIONS = Direction.values();
        REPLACE = state -> {
            if (state.func_185904_a().equals(Material.field_151585_k)) {
                return true;
            }
            return state.func_185904_a().func_76222_j();
        };
    }
}

